/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.analyse;

import java.io.FileWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.Map;

public class CorpusAnalyse {
    public final static String NOM_SUJET_COMMUN = "Pot commun";
    public final static String NOM_SUJET_DIVERS = "A trier";

    private Map<String, SacArticles> listeSujets;

    public CorpusAnalyse(){
        listeSujets = new HashMap<String, SacArticles>();
        listeSujets.put(NOM_SUJET_DIVERS, new SacArticles(NOM_SUJET_DIVERS));
    }

    public void addSujet(SacArticles sac){
        SacArticles sac0 = listeSujets.get(sac.getTitre());
        if(sac0 != null){
            sac.addAll(sac0);
            removeSujet(sac0);
        }
        listeSujets.put(sac.getTitre(), sac);
    }

    public void removeSujet(SacArticles sac){
        listeSujets.remove(sac.getTitre());
    }

    public int getNbArticles(){
        int n = 0;
        for(SacArticles s : getSujets()){
            n += s.getArticles().length;
        }
        return n;
    }

    public void fusionneSujets(SacArticles[] sacs){
        for(int i=1; i<sacs.length; i++){
            sacs[0].addAll(sacs[i]);
            removeSujet(sacs[i]);
        }
    }

    public SacArticles getSujet(String titre){
        return listeSujets.get(titre);
    }

    public SacArticles[] getSujets(){
        SacArticles[] res = new SacArticles[listeSujets.values().size()];
        listeSujets.values().toArray(res);
        return res;
    }

    public CorpusAnalyse getBackup(){
        CorpusAnalyse backup = new CorpusAnalyse();
        SacArticles[] aCopier = getSujets();
        for(int i=0; i<aCopier.length; i++){
            backup.addSujet(aCopier[i].clone());
        }
        return backup;
    }

    public String getSauvegarde(){
        String s = "<Corpus>\n";
        SacArticles[] aCopier = getSujets();
        for(int i=0; i<aCopier.length; i++){
            s += "<Sujet>\n"+aCopier[i].getSauvegarde()+"</Sujet>\n";
        }
        s += "</Corpus>";
        return s;
    }

    public void sauvegarde(FileWriter out) throws IOException {
        out.write("<Corpus>\n");
        SacArticles[] aCopier = getSujets();
        for(int i=0; i<aCopier.length; i++){
            out.write("<Sujet>\n");
            aCopier[i].sauvegarde(out);
            out.write("</Sujet>\n");
        }
        out.write("</Corpus>");
    }

    public static CorpusAnalyse charge(String sauvegarde){
        CorpusAnalyse res = new CorpusAnalyse();
        String[] s = sauvegarde.split("<Sujet>");
        for(int i=1; i<s.length; i++){ // index 0 = "<Corpus>"
            String save = s[i].substring(0, s[i].indexOf("</Sujet>")).trim();
            res.addSujet(SacArticles.charge(save));
        }
        return res;
    }

    @Override
    public boolean equals(Object o){
        if(!(o instanceof CorpusAnalyse)){
            return false;
        }
        CorpusAnalyse c = (CorpusAnalyse)o;
        return c.getSauvegarde().equals(getSauvegarde());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.listeSujets != null ? this.listeSujets.hashCode() : 0);
        return hash;
    }
}
